/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.quest;

import cpw.mods.fml.common.FMLLog;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import lotr.common.LOTRAchievement;
import lotr.common.LOTRDate;
import lotr.common.LOTRDimension;
import lotr.common.LOTRLore;
import lotr.common.LOTRMod;
import lotr.common.LOTRPlayerData;
import lotr.common.entity.npc.LOTREntityAngbandOrc;
import lotr.common.entity.npc.LOTREntityAngmarOrc;
import lotr.common.entity.npc.LOTREntityAvariElf;
import lotr.common.entity.npc.LOTREntityBlacklock;
import lotr.common.entity.npc.LOTREntityBlueDwarf;
import lotr.common.entity.npc.LOTREntityDaleMan;
import lotr.common.entity.npc.LOTREntityDolGuldurOrc;
import lotr.common.entity.npc.LOTREntityDolGuldurUruk;
import lotr.common.entity.npc.LOTREntityDurmethOrc;
import lotr.common.entity.npc.LOTREntityDwarf;
import lotr.common.entity.npc.LOTREntityEreborDwarf;
import lotr.common.entity.npc.LOTREntityGaladhrimElf;
import lotr.common.entity.npc.LOTREntityGondorMan;
import lotr.common.entity.npc.LOTREntityGundabadOrc;
import lotr.common.entity.npc.LOTREntityHalfTroll;
import lotr.common.entity.npc.LOTREntityHighElf;
import lotr.common.entity.npc.LOTREntityHobbit;
import lotr.common.entity.npc.LOTREntityIronfist;
import lotr.common.entity.npc.LOTREntityMoriaOrc;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.entity.npc.LOTREntityRivendellElf;
import lotr.common.entity.npc.LOTREntityStiffbeard;
import lotr.common.entity.npc.LOTREntityStonefoot;
import lotr.common.entity.npc.LOTREntityTauredain;
import lotr.common.entity.npc.LOTREntityUrukHai;
import lotr.common.entity.npc.LOTREntityWindDwarf;
import lotr.common.entity.npc.LOTREntityWoodElf;
import lotr.common.entity.npc.LOTRHiredNPCInfo;
import lotr.common.entity.npc.LOTRSpeech;
import lotr.common.entity.npc.LOTRUnitTradeEntry;
import lotr.common.fac.LOTRAlignmentBonusMap;
import lotr.common.fac.LOTRAlignmentValues;
import lotr.common.fac.LOTRFaction;
import lotr.common.item.LOTRItemCoin;
import lotr.common.item.LOTRItemModifierTemplate;
import lotr.common.quest.LOTRMiniQuestBounty;
import lotr.common.quest.LOTRMiniQuestCollect;
import lotr.common.quest.LOTRMiniQuestEvent;
import lotr.common.quest.LOTRMiniQuestFactory;
import lotr.common.quest.LOTRMiniQuestKillEntity;
import lotr.common.quest.LOTRMiniQuestKillFaction;
import lotr.common.quest.LOTRMiniQuestPickpocket;
import lotr.common.quest.LOTRMiniQuestWelcome;
import lotr.common.world.biome.LOTRBiome;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.biome.BiomeGenBase;
import org.apache.commons.lang3.tuple.Pair;

public abstract class LOTRMiniQuest {
    private static Map<String, Class<? extends LOTRMiniQuest>> nameToQuestMapping = new HashMap<String, Class<? extends LOTRMiniQuest>>();
    private static Map<Class<? extends LOTRMiniQuest>, String> questToNameMapping = new HashMap<Class<? extends LOTRMiniQuest>, String>();
    public static int MAX_MINIQUESTS_PER_FACTION;
    public static double RENDER_HEAD_DISTANCE;
    public LOTRMiniQuestFactory questGroup;
    private LOTRPlayerData playerData;
    public UUID questUUID;
    public UUID entityUUID;
    public String entityName;
    public String entityNameFull;
    public LOTRFaction entityFaction;
    private int questColor;
    public int dateGiven;
    public LOTRBiome biomeGiven;
    public float rewardFactor = 1.0f;
    public static final float defaultRewardFactor = 1.0f;
    public boolean willHire = false;
    public float hiringAlignment;
    public List<ItemStack> rewardItemTable = new ArrayList<ItemStack>();
    private boolean completed;
    public int dateCompleted;
    public int coinsRewarded;
    public float alignmentRewarded;
    public boolean wasHired;
    public List<ItemStack> itemsRewarded = new ArrayList<ItemStack>();
    private boolean entityDead;
    private Pair<ChunkCoordinates, Integer> lastLocation;
    public String speechBankStart;
    public String speechBankProgress;
    public String speechBankComplete;
    public String speechBankTooMany;
    public String quoteStart;
    public String quoteComplete;
    public List<String> quotesStages = new ArrayList<String>();

    private static void registerQuestType(String name, Class<? extends LOTRMiniQuest> questType) {
        nameToQuestMapping.put(name, questType);
        questToNameMapping.put(questType, name);
    }

    public LOTRMiniQuest(LOTRPlayerData pd) {
        this.playerData = pd;
        this.questUUID = UUID.randomUUID();
    }

    public void setPlayerData(LOTRPlayerData pd) {
        this.playerData = pd;
    }

    public LOTRPlayerData getPlayerData() {
        return this.playerData;
    }

    public void setNPCInfo(LOTREntityNPC npc) {
        this.entityUUID = npc.func_110124_au();
        this.entityName = npc.getNPCName();
        this.entityNameFull = npc.func_70005_c_();
        this.entityFaction = npc.getFaction();
        this.questColor = npc.getMiniquestColor();
    }

    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagCompound itemData;
        NBTTagList itemTags;
        nbt.func_74778_a("QuestType", questToNameMapping.get(this.getClass()));
        if (this.questGroup != null) {
            nbt.func_74778_a("QuestGroup", this.questGroup.getBaseName());
        }
        nbt.func_74778_a("QuestUUID", this.questUUID.toString());
        nbt.func_74778_a("EntityUUID", this.entityUUID.toString());
        nbt.func_74778_a("Owner", this.entityName);
        nbt.func_74778_a("OwnerFull", this.entityNameFull);
        nbt.func_74778_a("Faction", this.entityFaction.codeName());
        nbt.func_74768_a("Color", this.questColor);
        nbt.func_74768_a("DateGiven", this.dateGiven);
        if (this.biomeGiven != null) {
            nbt.func_74774_a("BiomeID", (byte)this.biomeGiven.field_76756_M);
            nbt.func_74778_a("BiomeDim", this.biomeGiven.biomeDimension.dimensionName);
        }
        nbt.func_74776_a("RewardFactor", this.rewardFactor);
        nbt.func_74757_a("WillHire", this.willHire);
        nbt.func_74776_a("HiringAlignF", this.hiringAlignment);
        if (!this.rewardItemTable.isEmpty()) {
            itemTags = new NBTTagList();
            for (ItemStack item : this.rewardItemTable) {
                itemData = new NBTTagCompound();
                item.func_77955_b(itemData);
                itemTags.func_74742_a((NBTBase)itemData);
            }
            nbt.func_74782_a("RewardItemTable", (NBTBase)itemTags);
        }
        nbt.func_74757_a("Completed", this.completed);
        nbt.func_74768_a("DateCompleted", this.dateCompleted);
        nbt.func_74777_a("CoinReward", (short)this.coinsRewarded);
        nbt.func_74776_a("AlignRewardF", this.alignmentRewarded);
        nbt.func_74757_a("WasHired", this.wasHired);
        if (!this.itemsRewarded.isEmpty()) {
            itemTags = new NBTTagList();
            for (ItemStack item : this.itemsRewarded) {
                itemData = new NBTTagCompound();
                item.func_77955_b(itemData);
                itemTags.func_74742_a((NBTBase)itemData);
            }
            nbt.func_74782_a("ItemRewards", (NBTBase)itemTags);
        }
        nbt.func_74757_a("OwnerDead", this.entityDead);
        if (this.lastLocation != null) {
            ChunkCoordinates coords = (ChunkCoordinates)this.lastLocation.getLeft();
            nbt.func_74768_a("XPos", coords.field_71574_a);
            nbt.func_74768_a("YPos", coords.field_71572_b);
            nbt.func_74768_a("ZPos", coords.field_71573_c);
            nbt.func_74768_a("Dimension", ((Integer)this.lastLocation.getRight()).intValue());
        }
        nbt.func_74778_a("SpeechStart", this.speechBankStart);
        nbt.func_74778_a("SpeechProgress", this.speechBankProgress);
        nbt.func_74778_a("SpeechComplete", this.speechBankComplete);
        nbt.func_74778_a("SpeechTooMany", this.speechBankTooMany);
        nbt.func_74778_a("QuoteStart", this.quoteStart);
        nbt.func_74778_a("QuoteComplete", this.quoteComplete);
        if (!this.quotesStages.isEmpty()) {
            NBTTagList stageTags = new NBTTagList();
            for (String s : this.quotesStages) {
                stageTags.func_74742_a((NBTBase)new NBTTagString(s));
            }
            nbt.func_74782_a("QuotesStages", (NBTBase)stageTags);
        }
    }

    public void readFromNBT(NBTTagCompound nbt) {
        String recovery;
        ItemStack item;
        NBTTagCompound itemData;
        int l;
        NBTTagList itemTags;
        UUID u;
        LOTRMiniQuestFactory factory;
        if (nbt.func_74764_b("QuestGroup") && (factory = LOTRMiniQuestFactory.forName(nbt.func_74779_i("QuestGroup"))) != null) {
            this.questGroup = factory;
        }
        if (nbt.func_74764_b("QuestUUID") && (u = UUID.fromString(nbt.func_74779_i("QuestUUID"))) != null) {
            this.questUUID = u;
        }
        this.entityUUID = nbt.func_74764_b("UUIDMost") && nbt.func_74764_b("UUIDLeast") ? new UUID(nbt.func_74763_f("UUIDMost"), nbt.func_74763_f("UUIDLeast")) : UUID.fromString(nbt.func_74779_i("EntityUUID"));
        this.entityName = nbt.func_74779_i("Owner");
        this.entityNameFull = nbt.func_74764_b("OwnerFull") ? nbt.func_74779_i("OwnerFull") : this.entityName;
        this.entityFaction = LOTRFaction.forName(nbt.func_74779_i("Faction"));
        this.questColor = nbt.func_74764_b("Color") ? nbt.func_74762_e("Color") : this.entityFaction.getFactionColor();
        this.dateGiven = nbt.func_74762_e("DateGiven");
        if (nbt.func_74764_b("BiomeID")) {
            int biomeID = nbt.func_74771_c("BiomeID") & 0xFF;
            String biomeDimName = nbt.func_74779_i("BiomeDim");
            LOTRDimension biomeDim = LOTRDimension.forName(biomeDimName);
            if (biomeDim != null) {
                this.biomeGiven = biomeDim.biomeList[biomeID];
            }
        }
        this.rewardFactor = nbt.func_74764_b("RewardFactor") ? nbt.func_74760_g("RewardFactor") : 1.0f;
        this.willHire = nbt.func_74767_n("WillHire");
        this.hiringAlignment = nbt.func_74764_b("HiringAlignment") ? (float)nbt.func_74762_e("HiringAlignment") : nbt.func_74760_g("HiringAlignF");
        this.rewardItemTable.clear();
        if (nbt.func_74764_b("RewardItemTable")) {
            itemTags = nbt.func_150295_c("RewardItemTable", 10);
            for (l = 0; l < itemTags.func_74745_c(); ++l) {
                itemData = itemTags.func_150305_b(l);
                item = ItemStack.func_77949_a((NBTTagCompound)itemData);
                if (item == null) continue;
                this.rewardItemTable.add(item);
            }
        }
        this.completed = nbt.func_74767_n("Completed");
        this.dateCompleted = nbt.func_74762_e("DateCompleted");
        this.coinsRewarded = nbt.func_74765_d("CoinReward");
        this.alignmentRewarded = nbt.func_74764_b("AlignmentReward") ? (float)nbt.func_74765_d("AlignmentReward") : nbt.func_74760_g("AlignRewardF");
        this.wasHired = nbt.func_74767_n("WasHired");
        this.itemsRewarded.clear();
        if (nbt.func_74764_b("ItemRewards")) {
            itemTags = nbt.func_150295_c("ItemRewards", 10);
            for (l = 0; l < itemTags.func_74745_c(); ++l) {
                itemData = itemTags.func_150305_b(l);
                item = ItemStack.func_77949_a((NBTTagCompound)itemData);
                if (item == null) continue;
                this.itemsRewarded.add(item);
            }
        }
        this.entityDead = nbt.func_74767_n("OwnerDead");
        if (nbt.func_74764_b("Dimension")) {
            ChunkCoordinates coords = new ChunkCoordinates(nbt.func_74762_e("XPos"), nbt.func_74762_e("YPos"), nbt.func_74762_e("ZPos"));
            int dimension = nbt.func_74762_e("Dimension");
            this.lastLocation = Pair.of((Object)coords, (Object)dimension);
        }
        this.speechBankStart = nbt.func_74779_i("SpeechStart");
        this.speechBankProgress = nbt.func_74779_i("SpeechProgress");
        this.speechBankComplete = nbt.func_74779_i("SpeechComplete");
        this.speechBankTooMany = nbt.func_74779_i("SpeechTooMany");
        this.quoteStart = nbt.func_74779_i("QuoteStart");
        this.quoteComplete = nbt.func_74779_i("QuoteComplete");
        this.quotesStages.clear();
        if (nbt.func_74764_b("QuotesStages")) {
            NBTTagList stageTags = nbt.func_150295_c("QuotesStages", 8);
            for (int l2 = 0; l2 < stageTags.func_74745_c(); ++l2) {
                String s = stageTags.func_150307_f(l2);
                this.quotesStages.add(s);
            }
        }
        if (this.questGroup == null && (recovery = this.speechBankStart) != null) {
            LOTRMiniQuestFactory factory2;
            int i1 = recovery.indexOf("/", 0);
            int i2 = recovery.indexOf("/", i1 + 1);
            if (i1 >= 0 && i2 >= 0 && (factory2 = LOTRMiniQuestFactory.forName(recovery = recovery.substring(i1 + 1, i2))) != null) {
                this.questGroup = factory2;
            }
        }
    }

    public static LOTRMiniQuest loadQuestFromNBT(NBTTagCompound nbt, LOTRPlayerData playerData) {
        String questTypeName = nbt.func_74779_i("QuestType");
        Class<? extends LOTRMiniQuest> questType = nameToQuestMapping.get(questTypeName);
        if (questType == null) {
            FMLLog.severe((String)("Could not instantiate miniquest of type " + questTypeName), (Object[])new Object[0]);
            return null;
        }
        LOTRMiniQuest quest = LOTRMiniQuest.newQuestInstance(questType, playerData);
        quest.readFromNBT(nbt);
        if (quest.isValidQuest()) {
            return quest;
        }
        FMLLog.severe((String)("Loaded an invalid LOTR miniquest " + quest.speechBankStart), (Object[])new Object[0]);
        return null;
    }

    private static <Q extends LOTRMiniQuest> Q newQuestInstance(Class<Q> questType, LOTRPlayerData playerData) {
        try {
            LOTRMiniQuest quest = (LOTRMiniQuest)questType.getConstructor(LOTRPlayerData.class).newInstance(playerData);
            return (Q)quest;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean isValidQuest() {
        return this.entityUUID != null && this.entityFaction != null;
    }

    public boolean canPlayerAccept(EntityPlayer entityplayer) {
        return true;
    }

    public String getFactionSubtitle() {
        if (this.entityFaction.isPlayableAlignmentFaction()) {
            return this.entityFaction.factionName();
        }
        return "";
    }

    public final int getQuestColor() {
        return this.questColor;
    }

    public final float[] getQuestColorComponents() {
        return new Color(this.getQuestColor()).getColorComponents(null);
    }

    public abstract String getQuestObjective();

    public abstract String getObjectiveInSpeech();

    public abstract String getProgressedObjectiveInSpeech();

    public abstract String getQuestProgress();

    public abstract String getQuestProgressShorthand();

    public abstract float getCompletionFactor();

    public abstract ItemStack getQuestIcon();

    public void onInteract(EntityPlayer entityplayer, LOTREntityNPC npc) {
    }

    public boolean onInteractOther(EntityPlayer entityplayer, LOTREntityNPC npc) {
        return false;
    }

    protected void sendProgressSpeechbank(EntityPlayer entityplayer, LOTREntityNPC npc) {
        npc.sendSpeechBank(entityplayer, this.speechBankProgress, this);
    }

    protected void sendCompletedSpeech(EntityPlayer entityplayer, LOTREntityNPC npc) {
        this.sendQuoteSpeech(entityplayer, npc, this.quoteComplete);
    }

    protected void sendQuoteSpeech(EntityPlayer entityplayer, LOTREntityNPC npc, String quote) {
        LOTRSpeech.sendSpeech(entityplayer, npc, LOTRSpeech.formatSpeech(quote, entityplayer, null, this.getObjectiveInSpeech()));
        npc.markNPCSpoken();
    }

    public void onKill(EntityPlayer entityplayer, EntityLivingBase entity) {
    }

    public void onKilledByPlayer(EntityPlayer entityplayer, EntityPlayer killer) {
    }

    public void onPlayerTick(EntityPlayer entityplayer) {
    }

    public void handleEvent(LOTRMiniQuestEvent event) {
    }

    public final boolean isActive() {
        return !this.isCompleted() && !this.isFailed();
    }

    public boolean isFailed() {
        return this.entityDead;
    }

    public String getQuestFailure() {
        return StatCollector.func_74837_a((String)"lotr.gui.redBook.mq.diary.dead", (Object[])new Object[]{this.entityName});
    }

    public String getQuestFailureShorthand() {
        return StatCollector.func_74838_a((String)"lotr.gui.redBook.mq.dead");
    }

    public void setEntityDead() {
        this.entityDead = true;
        this.updateQuest();
    }

    public void start(EntityPlayer entityplayer, LOTREntityNPC npc) {
        this.setNPCInfo(npc);
        this.dateGiven = LOTRDate.ShireReckoning.currentDay;
        int i = MathHelper.func_76128_c((double)entityplayer.field_70165_t);
        int k = MathHelper.func_76128_c((double)entityplayer.field_70161_v);
        BiomeGenBase biome = entityplayer.field_70170_p.func_72807_a(i, k);
        if (biome instanceof LOTRBiome) {
            this.biomeGiven = (LOTRBiome)biome;
        }
        this.playerData.addMiniQuest(this);
        npc.questInfo.addActiveQuestPlayer(entityplayer);
        this.playerData.setTrackingMiniQuest(this);
    }

    public boolean isCompleted() {
        return this.completed;
    }

    protected void complete(EntityPlayer entityplayer, LOTREntityNPC npc) {
        LOTRAchievement achievement;
        int coins;
        this.completed = true;
        this.dateCompleted = LOTRDate.ShireReckoning.currentDay;
        Random rand = npc.func_70681_au();
        ArrayList<ItemStack> dropItems = new ArrayList<ItemStack>();
        float alignment = this.getAlignmentBonus();
        if (alignment != 0.0f) {
            alignment *= MathHelper.func_151240_a((Random)rand, (float)0.75f, (float)1.25f);
            alignment = Math.max(alignment, 1.0f);
            LOTRAlignmentValues.AlignmentBonus bonus = LOTRAlignmentValues.createMiniquestBonus(alignment);
            LOTRFaction rewardFaction = this.getAlignmentRewardFaction();
            if (!this.questGroup.isNoAlignRewardForEnemy() || this.playerData.getAlignment(rewardFaction) >= 0.0f) {
                LOTRAlignmentBonusMap alignmentMap = this.playerData.addAlignment(entityplayer, bonus, rewardFaction, (Entity)npc);
                this.alignmentRewarded = ((Float)alignmentMap.get((Object)rewardFaction)).floatValue();
            }
        }
        if ((coins = this.getCoinBonus()) != 0) {
            if (this.shouldRandomiseCoinReward()) {
                coins = Math.round((float)coins * MathHelper.func_151240_a((Random)rand, (float)0.75f, (float)1.25f));
                if (rand.nextInt(12) == 0) {
                    coins *= MathHelper.func_76136_a((Random)rand, (int)2, (int)5);
                }
            }
            this.coinsRewarded = coins = Math.max(coins, 1);
            int coinsRemain = coins;
            for (int l = LOTRItemCoin.values.length - 1; l >= 0; --l) {
                int coinValue = LOTRItemCoin.values[l];
                if (coinsRemain < coinValue) continue;
                int numCoins = coinsRemain / coinValue;
                coinsRemain -= numCoins * coinValue;
                while (numCoins > 64) {
                    numCoins -= 64;
                    dropItems.add(new ItemStack(LOTRMod.silverCoin, 64, l));
                }
                dropItems.add(new ItemStack(LOTRMod.silverCoin, numCoins, l));
            }
        }
        if (!this.rewardItemTable.isEmpty()) {
            ItemStack item = this.rewardItemTable.get(rand.nextInt(this.rewardItemTable.size()));
            dropItems.add(item.func_77946_l());
            this.itemsRewarded.add(item.func_77946_l());
        }
        if (this.canRewardVariousExtraItems()) {
            LOTRLore lore;
            if (rand.nextInt(10) == 0 && this.questGroup != null && !this.questGroup.getLoreCategories().isEmpty() && (lore = LOTRLore.getMultiRandomLore(this.questGroup.getLoreCategories(), rand, true)) != null) {
                ItemStack loreBook = lore.createLoreBook(rand);
                dropItems.add(loreBook.func_77946_l());
                this.itemsRewarded.add(loreBook.func_77946_l());
            }
            if (rand.nextInt(15) == 0) {
                ItemStack modItem = LOTRItemModifierTemplate.getRandomCommonTemplate(rand);
                dropItems.add(modItem.func_77946_l());
                this.itemsRewarded.add(modItem.func_77946_l());
            }
            if (rand.nextInt(35) == 0) {
                Item[] spells = new Item[]{LOTRMod.spell_damage, LOTRMod.spell_fastdigger, LOTRMod.spell_fastrun, LOTRMod.spell_heal, LOTRMod.spell_healthboost, LOTRMod.spell_invision, LOTRMod.spell_jump, LOTRMod.spell_momentheal, LOTRMod.spell_resistance, LOTRMod.spell_saturation};
                Item randomSpell = spells[rand.nextInt(spells.length)];
                ItemStack randomSpellStack = new ItemStack(randomSpell);
                dropItems.add(randomSpellStack);
            }
            if (rand.nextInt(30) == 0) {
                int count = rand.nextInt(4) + 1;
                ItemStack mithrilBook1 = new ItemStack(LOTRMod.cloth2, count);
                dropItems.add(mithrilBook1.func_77946_l());
                this.itemsRewarded.add(mithrilBook1.func_77946_l());
            }
            if (rand.nextInt(70) == 0) {
                ItemStack mithrilBook1 = new ItemStack(LOTRMod.elderScroll, 1);
                dropItems.add(mithrilBook1.func_77946_l());
                this.itemsRewarded.add(mithrilBook1.func_77946_l());
            }
            if (rand.nextInt(20) == 0) {
                int count = rand.nextInt(4) + 1;
                ItemStack mithrilBook2 = new ItemStack(LOTRMod.cloth, count);
                dropItems.add(mithrilBook2.func_77946_l());
                this.itemsRewarded.add(mithrilBook2.func_77946_l());
            }
            if (npc instanceof LOTREntityGaladhrimElf) {
                if (rand.nextInt(50) == 0) {
                    ItemStack mithrilBook = new ItemStack(LOTRMod.arven);
                    dropItems.add(mithrilBook.func_77946_l());
                    this.itemsRewarded.add(mithrilBook.func_77946_l());
                }
                if (rand.nextInt(20) == 0) {
                    ItemStack mithrilBook = new ItemStack(LOTRMod.magicBook);
                    dropItems.add(mithrilBook.func_77946_l());
                    this.itemsRewarded.add(mithrilBook.func_77946_l());
                }
            }
            if (npc instanceof LOTREntityRivendellElf) {
                if (rand.nextInt(70) == 0) {
                    ItemStack mithrilBook = new ItemStack(LOTRMod.elrondsilver);
                    dropItems.add(mithrilBook.func_77946_l());
                    this.itemsRewarded.add(mithrilBook.func_77946_l());
                }
                if (rand.nextInt(70) == 0) {
                    ItemStack mithrilBook = new ItemStack(LOTRMod.elrondgold);
                    dropItems.add(mithrilBook.func_77946_l());
                    this.itemsRewarded.add(mithrilBook.func_77946_l());
                }
                if (rand.nextInt(50) == 0) {
                    ItemStack mithrilBook = new ItemStack(LOTRMod.arven);
                    dropItems.add(mithrilBook.func_77946_l());
                    this.itemsRewarded.add(mithrilBook.func_77946_l());
                }
                if (rand.nextInt(20) == 0) {
                    ItemStack mithrilBook = new ItemStack(LOTRMod.magicBook);
                    dropItems.add(mithrilBook.func_77946_l());
                    this.itemsRewarded.add(mithrilBook.func_77946_l());
                }
            }
            if (npc instanceof LOTREntityHighElf) {
                if (rand.nextInt(50) == 0) {
                    ItemStack mithrilBook = new ItemStack(LOTRMod.arven);
                    dropItems.add(mithrilBook.func_77946_l());
                    this.itemsRewarded.add(mithrilBook.func_77946_l());
                }
                if (rand.nextInt(20) == 0) {
                    ItemStack mithrilBook = new ItemStack(LOTRMod.magicBook);
                    dropItems.add(mithrilBook.func_77946_l());
                    this.itemsRewarded.add(mithrilBook.func_77946_l());
                }
                if (rand.nextInt(30) == 0) {
                    ItemStack mithrilBook = new ItemStack(LOTRMod.flyRing);
                    dropItems.add(mithrilBook.func_77946_l());
                    this.itemsRewarded.add(mithrilBook.func_77946_l());
                }
                if (rand.nextInt(40) == 0) {
                    ItemStack dragonArrows = new ItemStack(LOTRMod.arrowFall, 4);
                    dropItems.add(dragonArrows.func_77946_l());
                    this.itemsRewarded.add(dragonArrows.func_77946_l());
                }
            }
            if (npc instanceof LOTREntityDaleMan) {
                if (rand.nextInt(20) == 0) {
                    ItemStack mithrilBook = new ItemStack(LOTRMod.arrowDragon);
                    dropItems.add(mithrilBook.func_77946_l());
                    this.itemsRewarded.add(mithrilBook.func_77946_l());
                }
                if (rand.nextInt(100) == 0) {
                    ItemStack mithrilBook = new ItemStack(LOTRMod.arrowDragon, 4);
                    dropItems.add(mithrilBook.func_77946_l());
                    this.itemsRewarded.add(mithrilBook.func_77946_l());
                }
                if (rand.nextInt(80) == 0) {
                    ItemStack mithrilBook = new ItemStack(LOTRMod.arrowDragon, 3);
                    dropItems.add(mithrilBook.func_77946_l());
                    this.itemsRewarded.add(mithrilBook.func_77946_l());
                }
                if (rand.nextInt(30) == 0) {
                    ItemStack mithrilBook = new ItemStack(LOTRMod.arrowDragon, 2);
                    dropItems.add(mithrilBook.func_77946_l());
                    this.itemsRewarded.add(mithrilBook.func_77946_l());
                }
                if (rand.nextInt(20) == 0) {
                    ItemStack mithrilBook = new ItemStack(LOTRMod.bowPart, 1, 0);
                    dropItems.add(mithrilBook.func_77946_l());
                    this.itemsRewarded.add(mithrilBook.func_77946_l());
                }
                if (rand.nextInt(20) == 0) {
                    ItemStack mithrilBook = new ItemStack(LOTRMod.bowPart, 1, 1);
                    dropItems.add(mithrilBook.func_77946_l());
                    this.itemsRewarded.add(mithrilBook.func_77946_l());
                }
                if (rand.nextInt(20) == 0) {
                    ItemStack mithrilBook = new ItemStack(LOTRMod.bowPart, 1, 2);
                    dropItems.add(mithrilBook.func_77946_l());
                    this.itemsRewarded.add(mithrilBook.func_77946_l());
                }
            }
            if (npc instanceof LOTREntityWoodElf) {
                if (rand.nextInt(70) == 0) {
                    ItemStack mithrilBook = new ItemStack(LOTRMod.thranduilsilver);
                    dropItems.add(mithrilBook.func_77946_l());
                    this.itemsRewarded.add(mithrilBook.func_77946_l());
                }
                if (rand.nextInt(70) == 0) {
                    ItemStack mithrilBook = new ItemStack(LOTRMod.thranduilsnake);
                    dropItems.add(mithrilBook.func_77946_l());
                    this.itemsRewarded.add(mithrilBook.func_77946_l());
                }
                if (rand.nextInt(70) == 0) {
                    ItemStack mithrilBook = new ItemStack(LOTRMod.thranduilmithril);
                    dropItems.add(mithrilBook.func_77946_l());
                    this.itemsRewarded.add(mithrilBook.func_77946_l());
                }
                if (rand.nextInt(20) == 0) {
                    ItemStack mithrilBook = new ItemStack(LOTRMod.snakeBook);
                    dropItems.add(mithrilBook.func_77946_l());
                    this.itemsRewarded.add(mithrilBook.func_77946_l());
                }
                if (rand.nextInt(10) == 0) {
                    ItemStack mithrilBook = new ItemStack(LOTRMod.arrowWeak, 16);
                    dropItems.add(mithrilBook.func_77946_l());
                    this.itemsRewarded.add(mithrilBook.func_77946_l());
                }
            }
            if (npc instanceof LOTREntityHalfTroll && rand.nextInt(20) == 0) {
                ItemStack mithrilBook = new ItemStack(LOTRMod.rockBook);
                dropItems.add(mithrilBook.func_77946_l());
                this.itemsRewarded.add(mithrilBook.func_77946_l());
            }
            if (npc instanceof LOTREntityIronfist || npc instanceof LOTREntityStonefoot || npc instanceof LOTREntityStiffbeard || npc instanceof LOTREntityBlacklock) {
                if (rand.nextInt(20) == 0) {
                    ItemStack mithrilBook = new ItemStack(LOTRMod.rockBook);
                    dropItems.add(mithrilBook.func_77946_l());
                    this.itemsRewarded.add(mithrilBook.func_77946_l());
                }
                if (rand.nextInt(30) == 0) {
                    ItemStack mithrilBook = new ItemStack(LOTRMod.rhunFirePotDwarven, 4);
                    dropItems.add(mithrilBook.func_77946_l());
                    this.itemsRewarded.add(mithrilBook.func_77946_l());
                }
            }
            if (npc instanceof LOTREntityTauredain) {
                if (rand.nextInt(80) == 0) {
                    ItemStack mithrilBook = new ItemStack(LOTRMod.totemOfUndying);
                    dropItems.add(mithrilBook.func_77946_l());
                    this.itemsRewarded.add(mithrilBook.func_77946_l());
                }
                if (rand.nextInt(100) == 0) {
                    ItemStack mithrilBook = new ItemStack(LOTRMod.totemOfUndyingPlus);
                    dropItems.add(mithrilBook.func_77946_l());
                    this.itemsRewarded.add(mithrilBook.func_77946_l());
                }
                if (rand.nextInt(100) == 0) {
                    ItemStack mithrilBook = new ItemStack(LOTRMod.ringShaman);
                    dropItems.add(mithrilBook.func_77946_l());
                    this.itemsRewarded.add(mithrilBook.func_77946_l());
                }
            }
            if (npc instanceof LOTREntityAvariElf) {
                if (rand.nextInt(20) == 0) {
                    ItemStack mithrilBook = new ItemStack(LOTRMod.snakeBook);
                    dropItems.add(mithrilBook.func_77946_l());
                    this.itemsRewarded.add(mithrilBook.func_77946_l());
                }
                if (rand.nextInt(10) == 0) {
                    ItemStack mithrilBook = new ItemStack(LOTRMod.arrowAvari, 16);
                    dropItems.add(mithrilBook.func_77946_l());
                    this.itemsRewarded.add(mithrilBook.func_77946_l());
                }
            }
            if (npc instanceof LOTREntityHobbit) {
                if (rand.nextInt(100) == 0) {
                    ItemStack mithrilBook = new ItemStack(LOTRMod.magicClover);
                    dropItems.add(mithrilBook.func_77946_l());
                    this.itemsRewarded.add(mithrilBook.func_77946_l());
                }
                if (rand.nextInt(60) == 0) {
                    ItemStack mithrilBook = new ItemStack(LOTRMod.ringClover);
                    dropItems.add(mithrilBook.func_77946_l());
                    this.itemsRewarded.add(mithrilBook.func_77946_l());
                }
                if (rand.nextInt(30) == 0) {
                    ItemStack mithrilBook = new ItemStack(LOTRMod.clover, 1, 1);
                    dropItems.add(mithrilBook.func_77946_l());
                    this.itemsRewarded.add(mithrilBook.func_77946_l());
                }
                if (rand.nextInt(150) == 0) {
                    ItemStack mithrilBook = new ItemStack(LOTRMod.magicCloverPlus);
                    dropItems.add(mithrilBook.func_77946_l());
                    this.itemsRewarded.add(mithrilBook.func_77946_l());
                }
                if (rand.nextInt(10) == 0) {
                    ItemStack mithrilBook = new ItemStack(LOTRMod.lumberBook);
                    dropItems.add(mithrilBook.func_77946_l());
                    this.itemsRewarded.add(mithrilBook.func_77946_l());
                }
            }
            if (npc instanceof LOTREntityUrukHai) {
                if (rand.nextInt(10) == 0) {
                    ItemStack mithrilBook = new ItemStack(LOTRMod.lumberBook);
                    dropItems.add(mithrilBook.func_77946_l());
                    this.itemsRewarded.add(mithrilBook.func_77946_l());
                }
                if (rand.nextInt(50) == 0) {
                    ItemStack mithrilBook = new ItemStack(LOTRMod.sarumanring);
                    dropItems.add(mithrilBook.func_77946_l());
                    this.itemsRewarded.add(mithrilBook.func_77946_l());
                }
            }
            if (npc instanceof LOTREntityGondorMan) {
                if (rand.nextInt(20) == 0) {
                    ItemStack mithrilBook = new ItemStack(LOTRMod.lumberBook);
                    dropItems.add(mithrilBook.func_77946_l());
                    this.itemsRewarded.add(mithrilBook.func_77946_l());
                }
                if (rand.nextInt(50) == 0) {
                    ItemStack mithrilBook = new ItemStack(LOTRMod.ringBarachir);
                    dropItems.add(mithrilBook.func_77946_l());
                    this.itemsRewarded.add(mithrilBook.func_77946_l());
                }
                if (rand.nextInt(60) == 0) {
                    ItemStack mithrilBook = new ItemStack(LOTRMod.numenor);
                    dropItems.add(mithrilBook.func_77946_l());
                    this.itemsRewarded.add(mithrilBook.func_77946_l());
                }
            }
            if (npc instanceof LOTREntityBlueDwarf) {
                if (rand.nextInt(100) == 0) {
                    ItemStack mithrilBook = new ItemStack(LOTRMod.dragonRingFram);
                    dropItems.add(mithrilBook.func_77946_l());
                    this.itemsRewarded.add(mithrilBook.func_77946_l());
                }
                if (rand.nextInt(50) == 0) {
                    ItemStack mithrilBook = new ItemStack(LOTRMod.dragonSlayerRing);
                    dropItems.add(mithrilBook.func_77946_l());
                    this.itemsRewarded.add(mithrilBook.func_77946_l());
                }
            }
            if (npc instanceof LOTREntityDwarf) {
                if (rand.nextInt(10) == 0) {
                    ItemStack mithrilBook = new ItemStack(LOTRMod.mithrilBook);
                    dropItems.add(mithrilBook.func_77946_l());
                    this.itemsRewarded.add(mithrilBook.func_77946_l());
                }
                if (rand.nextInt(45) == 0) {
                    ItemStack mithrilBook = new ItemStack(LOTRMod.ring_khain);
                    dropItems.add(mithrilBook.func_77946_l());
                    this.itemsRewarded.add(mithrilBook.func_77946_l());
                }
                if (rand.nextInt(65) == 0) {
                    ItemStack mithrilBook = new ItemStack(LOTRMod.ring_farin);
                    dropItems.add(mithrilBook.func_77946_l());
                    this.itemsRewarded.add(mithrilBook.func_77946_l());
                }
                if (rand.nextInt(90) == 0) {
                    ItemStack mithrilBook = new ItemStack(LOTRMod.diggingBook);
                    dropItems.add(mithrilBook.func_77946_l());
                    this.itemsRewarded.add(mithrilBook.func_77946_l());
                }
            }
            if (npc instanceof LOTREntityEreborDwarf) {
                if (rand.nextInt(110) == 0) {
                    ItemStack mithrilBook = new ItemStack(LOTRMod.diggingBook2);
                    dropItems.add(mithrilBook.func_77946_l());
                    this.itemsRewarded.add(mithrilBook.func_77946_l());
                }
                if (rand.nextInt(110) == 0) {
                    ItemStack mithrilBook = new ItemStack(LOTRMod.thorin);
                    dropItems.add(mithrilBook.func_77946_l());
                    this.itemsRewarded.add(mithrilBook.func_77946_l());
                }
                if (rand.nextInt(110) == 0) {
                    ItemStack mithrilBook = new ItemStack(LOTRMod.ereborHorn);
                    dropItems.add(mithrilBook.func_77946_l());
                    this.itemsRewarded.add(mithrilBook.func_77946_l());
                }
                if (rand.nextInt(50) == 0) {
                    ItemStack mithrilBook = new ItemStack(LOTRMod.stoneKili);
                    dropItems.add(mithrilBook.func_77946_l());
                    this.itemsRewarded.add(mithrilBook.func_77946_l());
                }
                if (rand.nextInt(100) == 0) {
                    ItemStack mithrilBook = new ItemStack(LOTRMod.stoneKiliPlus);
                    dropItems.add(mithrilBook.func_77946_l());
                    this.itemsRewarded.add(mithrilBook.func_77946_l());
                }
                if (rand.nextInt(110) == 0) {
                    ItemStack mithrilBook = new ItemStack(LOTRMod.thorinrune);
                    dropItems.add(mithrilBook.func_77946_l());
                    this.itemsRewarded.add(mithrilBook.func_77946_l());
                }
                if (rand.nextInt(1000) == 0) {
                    ItemStack mithrilBook = new ItemStack(LOTRMod.arcenstone);
                    dropItems.add(mithrilBook.func_77946_l());
                    this.itemsRewarded.add(mithrilBook.func_77946_l());
                }
            }
            if (npc instanceof LOTREntityWindDwarf) {
                if (rand.nextInt(30) == 0) {
                    ItemStack mithrilBook = new ItemStack(LOTRMod.stoneKili);
                    dropItems.add(mithrilBook.func_77946_l());
                    this.itemsRewarded.add(mithrilBook.func_77946_l());
                }
                if (rand.nextInt(50) == 0) {
                    ItemStack mithrilBook = new ItemStack(LOTRMod.stoneKiliPlus);
                    dropItems.add(mithrilBook.func_77946_l());
                    this.itemsRewarded.add(mithrilBook.func_77946_l());
                }
                if (rand.nextInt(100) == 0) {
                    ItemStack mithrilBook = new ItemStack(LOTRMod.bundle);
                    dropItems.add(mithrilBook.func_77946_l());
                    this.itemsRewarded.add(mithrilBook.func_77946_l());
                }
            }
            if (npc instanceof LOTREntityAngbandOrc) {
                if (rand.nextInt(110) == 0) {
                    ItemStack mithrilBook = new ItemStack(LOTRMod.chilling);
                    dropItems.add(mithrilBook.func_77946_l());
                    this.itemsRewarded.add(mithrilBook.func_77946_l());
                }
                if (rand.nextInt(10) == 0) {
                    ItemStack mithrilBook = new ItemStack(LOTRMod.arrowFire, 16);
                    dropItems.add(mithrilBook.func_77946_l());
                    this.itemsRewarded.add(mithrilBook.func_77946_l());
                }
                if (rand.nextInt(10) == 0) {
                    ItemStack mithrilBook = new ItemStack(LOTRMod.arrowSlow, 16);
                    dropItems.add(mithrilBook.func_77946_l());
                    this.itemsRewarded.add(mithrilBook.func_77946_l());
                }
                if (rand.nextInt(110) == 0) {
                    ItemStack mithrilBook = new ItemStack(LOTRMod.balrogFire);
                    dropItems.add(mithrilBook.func_77946_l());
                    this.itemsRewarded.add(mithrilBook.func_77946_l());
                }
            }
            if (npc instanceof LOTREntityDurmethOrc || npc instanceof LOTREntityGundabadOrc || npc instanceof LOTREntityMoriaOrc) {
                if (rand.nextInt(10) == 0) {
                    ItemStack mithrilBook = new ItemStack(LOTRMod.arrowPoisoned, 16);
                    dropItems.add(mithrilBook.func_77946_l());
                    this.itemsRewarded.add(mithrilBook.func_77946_l());
                }
                if (rand.nextInt(10) == 0) {
                    ItemStack mithrilBook = new ItemStack(LOTRMod.arrowHunger, 16);
                    dropItems.add(mithrilBook.func_77946_l());
                    this.itemsRewarded.add(mithrilBook.func_77946_l());
                }
            }
            if (npc instanceof LOTREntityAngmarOrc || npc instanceof LOTREntityDolGuldurOrc) {
                if (rand.nextInt(10) == 0) {
                    ItemStack mithrilBook = new ItemStack(LOTRMod.arrowWeak, 16);
                    dropItems.add(mithrilBook.func_77946_l());
                    this.itemsRewarded.add(mithrilBook.func_77946_l());
                }
                if (rand.nextInt(10) == 0) {
                    ItemStack mithrilBook = new ItemStack(LOTRMod.arrowMorgul, 16);
                    dropItems.add(mithrilBook.func_77946_l());
                    this.itemsRewarded.add(mithrilBook.func_77946_l());
                }
            }
            if (npc instanceof LOTREntityDolGuldurUruk) {
                if (rand.nextInt(50) == 0) {
                    ItemStack sword = new ItemStack(LOTRMod.swordDolGuldurUrukPoisoned);
                    dropItems.add(sword.func_77946_l());
                    this.itemsRewarded.add(sword.func_77946_l());
                }
                if (rand.nextInt(50) == 0) {
                    ItemStack sword = new ItemStack(LOTRMod.hammerDolGuldurUrukPoisoned);
                    dropItems.add(sword.func_77946_l());
                    this.itemsRewarded.add(sword.func_77946_l());
                }
                if (rand.nextInt(50) == 0) {
                    ItemStack sword = new ItemStack(LOTRMod.battleaxeDolGuldurUrukPoisoned);
                    dropItems.add(sword.func_77946_l());
                    this.itemsRewarded.add(sword.func_77946_l());
                }
                if (rand.nextInt(50) == 0) {
                    ItemStack sword = new ItemStack(LOTRMod.pikeDolGuldurUrukPoisoned);
                    dropItems.add(sword.func_77946_l());
                    this.itemsRewarded.add(sword.func_77946_l());
                }
            }
        }
        if (!dropItems.isEmpty()) {
            boolean givePouch;
            boolean bl = givePouch = this.canRewardVariousExtraItems() && rand.nextInt(10) == 0;
            if (givePouch) {
                ItemStack pouch = npc.createNPCPouchDrop();
                npc.fillPouchFromListAndRetainUnfilled(pouch, dropItems);
                npc.func_70099_a(pouch, 0.0f);
                ItemStack pouchCopy = pouch.func_77946_l();
                pouchCopy.func_77982_d(null);
                this.itemsRewarded.add(pouchCopy);
            }
            npc.dropItemList(dropItems);
        }
        if (this.willHire) {
            LOTRUnitTradeEntry tradeEntry = new LOTRUnitTradeEntry(npc.getClass(), 0, this.hiringAlignment);
            tradeEntry.setTask(LOTRHiredNPCInfo.Task.WARRIOR);
            npc.hiredNPCInfo.hireUnit(entityplayer, false, this.entityFaction, tradeEntry, null, npc.field_70154_o);
            this.wasHired = true;
        }
        this.updateQuest();
        this.playerData.completeMiniQuest(this);
        this.sendCompletedSpeech(entityplayer, npc);
        if (this.questGroup != null && (achievement = this.questGroup.getAchievement()) != null) {
            this.playerData.addAchievement(achievement);
        }
    }

    public final LOTRFaction getAlignmentRewardFaction() {
        return this.questGroup.checkAlignmentRewardFaction(this.entityFaction);
    }

    public boolean anyRewardsGiven() {
        return this.alignmentRewarded > 0.0f || this.coinsRewarded > 0 || !this.itemsRewarded.isEmpty();
    }

    public void updateLocation(LOTREntityNPC npc) {
        int i = MathHelper.func_76128_c((double)npc.field_70165_t);
        int j = MathHelper.func_76128_c((double)npc.field_70163_u);
        int k = MathHelper.func_76128_c((double)npc.field_70161_v);
        ChunkCoordinates coords = new ChunkCoordinates(i, j, k);
        int dim = npc.field_71093_bK;
        ChunkCoordinates prevCoords = null;
        if (this.lastLocation != null) {
            prevCoords = (ChunkCoordinates)this.lastLocation.getLeft();
        }
        this.lastLocation = Pair.of((Object)coords, (Object)dim);
        boolean sendUpdate = false;
        if (prevCoords == null) {
            sendUpdate = true;
        } else {
            boolean bl = sendUpdate = (double)coords.func_82371_e(prevCoords) > 256.0;
        }
        if (sendUpdate) {
            this.updateQuest();
        }
    }

    public ChunkCoordinates getLastLocation() {
        return this.lastLocation == null ? null : (ChunkCoordinates)this.lastLocation.getLeft();
    }

    protected void updateQuest() {
        this.playerData.updateMiniQuest(this);
    }

    public abstract float getAlignmentBonus();

    public abstract int getCoinBonus();

    protected boolean shouldRandomiseCoinReward() {
        return true;
    }

    protected boolean canRewardVariousExtraItems() {
        return true;
    }

    static {
        LOTRMiniQuest.registerQuestType("Collect", LOTRMiniQuestCollect.class);
        LOTRMiniQuest.registerQuestType("KillFaction", LOTRMiniQuestKillFaction.class);
        LOTRMiniQuest.registerQuestType("KillEntity", LOTRMiniQuestKillEntity.class);
        LOTRMiniQuest.registerQuestType("Bounty", LOTRMiniQuestBounty.class);
        LOTRMiniQuest.registerQuestType("Welcome", LOTRMiniQuestWelcome.class);
        LOTRMiniQuest.registerQuestType("Pickpocket", LOTRMiniQuestPickpocket.class);
        MAX_MINIQUESTS_PER_FACTION = 5;
        RENDER_HEAD_DISTANCE = 15.0;
    }

    public static abstract class QuestFactoryBase<Q extends LOTRMiniQuest> {
        private LOTRMiniQuestFactory questFactoryGroup;
        private String questName;
        private float rewardFactor = 1.0f;
        private boolean willHire = false;
        private float hiringAlignment;
        private List<ItemStack> rewardItems;

        public QuestFactoryBase(String name) {
            this.questName = name;
        }

        public void setFactoryGroup(LOTRMiniQuestFactory factory) {
            this.questFactoryGroup = factory;
        }

        public LOTRMiniQuestFactory getFactoryGroup() {
            return this.questFactoryGroup;
        }

        public QuestFactoryBase setRewardFactor(float f) {
            this.rewardFactor = f;
            return this;
        }

        public QuestFactoryBase setHiring(float f) {
            this.willHire = true;
            this.hiringAlignment = f;
            return this;
        }

        public QuestFactoryBase setRewardItems(ItemStack[] items) {
            this.rewardItems = Arrays.asList(items);
            return this;
        }

        public abstract Class<Q> getQuestClass();

        public Q createQuest(LOTREntityNPC npc, Random rand) {
            LOTRMiniQuest quest = LOTRMiniQuest.newQuestInstance(this.getQuestClass(), null);
            quest.questGroup = this.getFactoryGroup();
            String pathName = "miniquest/" + this.getFactoryGroup().getBaseName() + "/";
            String pathNameBaseSpeech = "miniquest/" + this.getFactoryGroup().getBaseSpeechGroup().getBaseName() + "/";
            String questPathName = pathName + this.questName + "_";
            quest.speechBankStart = questPathName + "start";
            quest.speechBankProgress = questPathName + "progress";
            quest.speechBankComplete = questPathName + "complete";
            quest.speechBankTooMany = pathNameBaseSpeech + "_tooMany";
            quest.quoteStart = LOTRSpeech.getRandomSpeech(quest.speechBankStart);
            quest.quoteComplete = LOTRSpeech.getRandomSpeech(quest.speechBankComplete);
            quest.setNPCInfo(npc);
            quest.rewardFactor = this.rewardFactor;
            quest.willHire = this.willHire;
            quest.hiringAlignment = this.hiringAlignment;
            if (this.rewardItems != null) {
                quest.rewardItemTable.addAll(this.rewardItems);
            }
            return (Q)quest;
        }
    }

    public static class SorterAlphabetical
    implements Comparator<LOTRMiniQuest> {
        @Override
        public int compare(LOTRMiniQuest q1, LOTRMiniQuest q2) {
            if (!q2.isActive() && q1.isActive()) {
                return 1;
            }
            if (!q1.isActive() && q2.isActive()) {
                return -1;
            }
            if (q1.entityFaction == q2.entityFaction) {
                return q1.entityName.compareTo(q2.entityName);
            }
            return Integer.valueOf(q1.entityFaction.ordinal()).compareTo(q2.entityFaction.ordinal());
        }
    }
}

